/* - MCBackEMFUpdateListener -
 * Display the data from a Back EMF update event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.event.BackEMFUpdateListener;
import com.phidgets.event.BackEMFUpdateEvent;

import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JCheckBox;

public class MCBackEMFUpdateListener implements BackEMFUpdateListener {

    private JComboBox motorCmb;
    private JTextField backEMFTxt;
    private JCheckBox backEMFChk;

    public MCBackEMFUpdateListener(JTextField backEMFTxt, JCheckBox backEMFChk, JComboBox motorCmb) {
        this.motorCmb = motorCmb;
        this.backEMFChk = backEMFChk;
        this.backEMFTxt = backEMFTxt;
    }

    public void backEMFUpdated(BackEMFUpdateEvent backEMFUpdateEvent) {

        if (backEMFChk.isSelected()) {
            if (backEMFUpdateEvent.getIndex() == ((Integer) motorCmb.getSelectedItem()).intValue()) {
                backEMFTxt.setText(Double.toString(backEMFUpdateEvent.getVoltage()));
            }
        }
    }
}
